/*
 * Decompiled with CFR 0.152.
 */
package morfeusz;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.URL;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import morfeusz.Morfeusz;
import morfeusz.PlaceHolder;
import pl.sgjp.morfeusz.MorphInterpretation;

public class ResultsPane
extends JTable {
    public static final String[] HEADERS1 = new String[]{"", "", "Forma", "Lemat", "Tag", "Nazwa", "Kwalifikatory"};
    public static final String[] HEADERS2 = new String[]{"Forma", "Lemat", "Tag", "Nazwa", "Kwalifikatory"};
    public static final Border emptyBorder = BorderFactory.createEmptyBorder(0, 2, 0, 2);
    public static final Border lineBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, -1, -1, -1), BorderFactory.createLineBorder(Color.lightGray)), BorderFactory.createEmptyBorder(0, 2, 0, 2));
    private Morfeusz controller;
    private JTable resultsTable;
    private ColumnSorter columnSorter;
    private List<MorphInterpretation> results;
    private HashSet<Integer> interpBoundaries;
    private PlaceHolder placeHolder;
    private String[] headers;
    private TableColumn[] tableColumns;
    private boolean analyze;
    private boolean columnsAreVisible;

    public ResultsPane(boolean bl, Morfeusz morfeusz, PlaceHolder placeHolder) {
        this.controller = morfeusz;
        this.analyze = bl;
        this.placeHolder = placeHolder;
        this.resultsTable = this;
        this.initTable();
    }

    public void initTable() {
        this.headers = this.analyze ? HEADERS1 : HEADERS2;
        TableViewModel tableViewModel = new TableViewModel();
        FontMetrics fontMetrics = this.getFontMetrics(Morfeusz.boldFont);
        this.columnSorter = new ColumnSorter();
        this.setModel(tableViewModel);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(-1, -1, 0, -1), BorderFactory.createLineBorder(Color.lightGray)));
        this.setBackground(Morfeusz.LIGHT_GRAY);
        this.setGridColor(Color.lightGray);
        this.setShowHorizontalLines(false);
        this.setAutoResizeMode(0);
        this.setRowSelectionAllowed(false);
        this.setRowHeight(fontMetrics.getHeight() + 4);
        TableColumnModel tableColumnModel = this.getColumnModel();
        RowRenderer rowRenderer = new RowRenderer();
        TableHeader tableHeader = new TableHeader(tableColumnModel);
        this.setTableHeader(tableHeader);
        this.tableColumns = new TableColumn[this.headers.length];
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn;
            this.tableColumns[i] = tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setHeaderValue(this.headers[i]);
            tableColumn.setCellRenderer(rowRenderer);
            tableColumn.setHeaderRenderer(tableHeader.getDefaultRenderer());
        }
        this.getTableHeader().setReorderingAllowed(false);
        this.columnsAreVisible = true;
        this.showColumns(false);
    }

    public void sortTable(int n) {
        if (this.controller.getPreferences().sortedColumn != n) {
            this.controller.getPreferences().sortedColumn = n;
            this.columnSorter.setSortedColumn(n);
            this.resetResults();
        }
    }

    public void showColumns(boolean bl) {
        if (this.columnsAreVisible != bl) {
            this.columnsAreVisible = bl;
            for (int i = 0; i < this.tableColumns.length; ++i) {
                if (bl) {
                    this.addColumn(this.tableColumns[i]);
                    continue;
                }
                this.removeColumn(this.tableColumns[i]);
            }
            if (bl) {
                TableColumnModel tableColumnModel = this.getColumnModel();
                for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                    TableColumn tableColumn = tableColumnModel.getColumn(i);
                    tableColumn.setHeaderRenderer(this.tableHeader.getDefaultRenderer());
                }
            }
        }
        this.placeHolder.showBottomLine(bl);
    }

    public void calculateSizes() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            Component component;
            Object object;
            TableCellRenderer tableCellRenderer;
            int n = 0;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            for (int j = 0; j < this.getRowCount(); ++j) {
                tableCellRenderer = this.getCellRenderer(j, i);
                object = this.getValueAt(j, i);
                component = tableCellRenderer.getTableCellRendererComponent(this, object, false, false, j, i);
                n = Math.max(component.getPreferredSize().width, n);
            }
            tableCellRenderer = tableColumn.getHeaderRenderer();
            object = tableColumn.getHeaderValue();
            component = tableCellRenderer.getTableCellRendererComponent(this, object, false, false, 0, i);
            n = Math.max(component.getPreferredSize().width, n);
            tableColumnModel.getColumn(i).setPreferredWidth(n + 4);
        }
    }

    public void changeFont() {
        FontMetrics fontMetrics = this.getFontMetrics(Morfeusz.boldFont);
        TableHeader tableHeader = new TableHeader(this.columnModel);
        TableColumnModel tableColumnModel = this.getColumnModel();
        this.setRowHeight(fontMetrics.getHeight() + 4);
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setHeaderRenderer(tableHeader.getDefaultRenderer());
        }
        this.calculateSizes();
        this.revalidate();
        this.repaint();
        this.getTableHeader().repaint();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setResults(List<MorphInterpretation> list, HashSet<Integer> hashSet) {
        this.results = list;
        this.interpBoundaries = hashSet;
        this.resetResults();
    }

    public void resetResults() {
        if (this.results == null) {
            this.showColumns(false);
        } else {
            if (!this.analyze) {
                Collections.sort(this.results, this.columnSorter);
            }
            this.showColumns(true);
            this.calculateSizes();
            this.revalidate();
            this.repaint();
        }
        this.getTableHeader().repaint();
    }

    public boolean newNode(int n) {
        boolean bl = true;
        if (n > 0) {
            MorphInterpretation morphInterpretation = this.results.get(n);
            MorphInterpretation morphInterpretation2 = this.results.get(n - 1);
            int n2 = morphInterpretation.getStartNode();
            int n3 = morphInterpretation.getEndNode();
            int n4 = morphInterpretation2.getStartNode();
            int n5 = morphInterpretation2.getEndNode();
            if (n2 == n4 && n3 == n5 && !this.interpBoundaries.contains(n)) {
                bl = false;
            }
        }
        return bl;
    }

    private class ColumnSorter
    implements Comparator<MorphInterpretation> {
        private Collator collator = Collator.getInstance(new Locale("pl", "PL"));
        private int sortedColumn;

        public ColumnSorter() {
            this.sortedColumn = ResultsPane.this.controller.getPreferences().sortedColumn;
        }

        public void setSortedColumn(int n) {
            this.sortedColumn = n;
        }

        @Override
        public int compare(MorphInterpretation morphInterpretation, MorphInterpretation morphInterpretation2) {
            if (this.sortedColumn == 0) {
                return this.compareForms(morphInterpretation, morphInterpretation2);
            }
            if (this.sortedColumn == 1) {
                return this.compareLemmas(morphInterpretation, morphInterpretation2);
            }
            return this.compareTags(morphInterpretation, morphInterpretation2);
        }

        public int compareForms(MorphInterpretation morphInterpretation, MorphInterpretation morphInterpretation2) {
            String string;
            String string2 = morphInterpretation.getOrth();
            int n = this.collator.compare(string2, string = morphInterpretation2.getOrth());
            if (n == 0) {
                string2 = morphInterpretation.getLemma();
                string = morphInterpretation2.getLemma();
                n = this.collator.compare(string2, string);
            }
            return n;
        }

        public int compareLemmas(MorphInterpretation morphInterpretation, MorphInterpretation morphInterpretation2) {
            String string;
            String string2 = morphInterpretation.getLemma();
            int n = this.collator.compare(string2, string = morphInterpretation2.getLemma());
            if (n == 0) {
                string2 = morphInterpretation.getOrth();
                string = morphInterpretation2.getOrth();
                n = this.collator.compare(string2, string);
            }
            return n;
        }

        public int compareTags(MorphInterpretation morphInterpretation, MorphInterpretation morphInterpretation2) {
            String string = morphInterpretation.getTag(ResultsPane.this.controller.getMorfeusz());
            String string2 = morphInterpretation2.getTag(ResultsPane.this.controller.getMorfeusz());
            return this.collator.compare(string, string2);
        }
    }

    private class HeaderRenderer
    implements TableCellRenderer {
        private JLabel renderer;
        private Icon startNode;
        private Icon endNode;
        private Icon downArrow;

        public HeaderRenderer() {
            Border border = UIManager.getBorder("TableHeader.cellBorder");
            this.renderer = new JLabel();
            this.renderer.setFont(Morfeusz.boldFont);
            this.renderer.setBorder(border);
            this.renderer.setBackground(UIManager.getColor("TableHeader.background"));
            this.renderer.setForeground(UIManager.getColor("TableHeader.foreground"));
            if (ResultsPane.this.analyze) {
                URL uRL = ClassLoader.getSystemClassLoader().getResource("start_node.gif");
                this.startNode = new ImageIcon(uRL);
                uRL = ClassLoader.getSystemClassLoader().getResource("end_node.gif");
                this.endNode = new ImageIcon(uRL);
            } else {
                URL uRL = ClassLoader.getSystemClassLoader().getResource("down.gif");
                this.downArrow = new ImageIcon(uRL);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.renderer.setText((String)object);
            if (ResultsPane.this.analyze) {
                if (n2 == 0) {
                    this.renderer.setIcon(this.startNode);
                    this.renderer.setHorizontalAlignment(0);
                } else if (n2 == 1) {
                    this.renderer.setIcon(this.endNode);
                    this.renderer.setHorizontalAlignment(0);
                } else {
                    this.renderer.setIcon(null);
                    this.renderer.setHorizontalAlignment(2);
                }
            } else {
                int n3 = ResultsPane.this.controller.getPreferences().sortedColumn;
                if (n2 == n3) {
                    this.renderer.setIcon(this.downArrow);
                } else {
                    this.renderer.setIcon(null);
                }
                this.renderer.setHorizontalAlignment(2);
            }
            return this.renderer;
        }
    }

    private class TableHeader
    extends JTableHeader {
        private PlaceHolder corner;
        private boolean initialized;
        private int cursorPos;
        private int column;

        public TableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
            this.corner = new PlaceHolder();
            this.initialized = false;
            this.cursorPos = -1;
            this.column = -1;
            this.setDefaultRenderer(new HeaderRenderer());
            this.setResizingAllowed(true);
            this.corner.setLocation(0, 0);
            this.corner.showBottomLine(ResultsPane.this.columnsAreVisible);
            this.add(this.corner);
            if (!ResultsPane.this.analyze) {
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        TableHeader.this.cursorPos = mouseEvent.getX();
                        TableColumnModel tableColumnModel = TableHeader.this.getColumnModel();
                        TableHeader.this.column = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                        if (TableHeader.this.column >= 0 && TableHeader.this.column <= 2) {
                            ResultsPane.this.sortTable(TableHeader.this.column);
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                        TableHeader.this.cursorPos = mouseEvent.getX();
                        TableColumnModel tableColumnModel = TableHeader.this.getColumnModel();
                        TableHeader.this.column = tableColumnModel.getColumnIndexAtX(TableHeader.this.cursorPos);
                        TableHeader.this.adjustCursor();
                    }
                });
                this.addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent mouseEvent) {
                        TableHeader.this.cursorPos = mouseEvent.getX();
                        TableColumnModel tableColumnModel = ResultsPane.this.resultsTable.getColumnModel();
                        int n = tableColumnModel.getColumnIndexAtX(TableHeader.this.cursorPos);
                        TableColumn tableColumn = null;
                        if (n >= 0 && n <= 2) {
                            tableColumn = tableColumnModel.getColumn(n);
                        }
                        if (tableColumn != null) {
                            if (n != TableHeader.this.column) {
                                switch (n) {
                                    case 0: {
                                        TableHeader.this.setToolTipText("Sortuj formy.");
                                        break;
                                    }
                                    case 1: {
                                        TableHeader.this.setToolTipText("Sortuj lematy.");
                                        break;
                                    }
                                    case 2: {
                                        TableHeader.this.setToolTipText("Sortuj tagi.");
                                        break;
                                    }
                                    default: {
                                        TableHeader.this.setToolTipText(null);
                                        break;
                                    }
                                }
                            }
                        } else {
                            TableHeader.this.setToolTipText(null);
                        }
                        if (n != TableHeader.this.column) {
                            TableHeader.this.column = n;
                        }
                        TableHeader.this.adjustCursor();
                    }
                });
            }
        }

        public void adjustCursor() {
            if (this.column >= 0 && this.column <= 2) {
                if (this.isResizeSpot(this.column, this.cursorPos)) {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                }
            } else if (this.isResizeSpot(this.column, this.cursorPos)) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }

        public boolean isResizeSpot(int n, int n2) {
            int n3;
            int n4;
            TableColumnModel tableColumnModel = ResultsPane.this.resultsTable.getColumnModel();
            Rectangle rectangle = this.getHeaderRect(n);
            int n5 = tableColumnModel.getColumnCount();
            if (n < 0 || n >= n5) {
                return false;
            }
            if (n == 0) {
                n4 = rectangle.x;
                n3 = n4 + rectangle.width - 3;
            } else {
                n4 = rectangle.x += 3;
                n3 = n4 + rectangle.width - 6;
            }
            return n2 < n4 || n2 >= n3;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            FontMetrics fontMetrics = this.getFontMetrics(Morfeusz.boldFont);
            dimension.height = fontMetrics.getHeight() + 4;
            return dimension;
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            this.moveCorner();
            this.initialized = true;
        }

        public void moveCorner() {
            TableColumnModel tableColumnModel = this.getColumnModel();
            Rectangle rectangle = this.getHeaderRect(tableColumnModel.getColumnCount() - 1);
            this.corner.setLocation(rectangle.x + rectangle.width, 0);
            this.corner.setSize(this.getWidth() - rectangle.x - rectangle.width, this.getHeight());
        }

        @Override
        public void resizeAndRepaint() {
            super.resizeAndRepaint();
            if (this.initialized) {
                this.moveCorner();
                this.corner.showBottomLine(ResultsPane.this.columnsAreVisible);
            }
        }
    }

    private class RowRenderer
    extends DefaultTableCellRenderer {
        private RowRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (ResultsPane.this.analyze) {
                boolean bl3;
                boolean bl4 = bl3 = ResultsPane.this.newNode(n) && n > 0;
                if (n2 <= 1) {
                    jLabel.setHorizontalAlignment(0);
                } else {
                    jLabel.setHorizontalAlignment(2);
                }
                if (n2 == 2) {
                    this.setFont(Morfeusz.boldFont);
                } else if (n2 == 5 || n2 == 6) {
                    this.setFont(Morfeusz.italicFont);
                } else {
                    this.setFont(Morfeusz.plainFont);
                }
                if (bl3) {
                    this.setBorder(lineBorder);
                } else {
                    this.setBorder(emptyBorder);
                }
            } else {
                if (n2 == 0) {
                    this.setFont(Morfeusz.boldFont);
                } else if (n2 == 1) {
                    this.setFont(Morfeusz.plainFont);
                } else {
                    this.setFont(Morfeusz.italicFont);
                }
                this.setBorder(emptyBorder);
            }
            if (n % 2 == 0) {
                this.setBackground(Morfeusz.VLIGHT_BLUE);
            } else {
                this.setBackground(Color.white);
            }
            this.setForeground(Color.black);
            this.setValue(object);
            return this;
        }
    }

    private class TableViewModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            if (ResultsPane.this.results == null) {
                return 0;
            }
            return ResultsPane.this.results.size();
        }

        @Override
        public int getColumnCount() {
            return ResultsPane.this.headers.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            boolean bl;
            MorphInterpretation morphInterpretation = ResultsPane.this.results.get(n);
            if (ResultsPane.this.analyze) {
                bl = ResultsPane.this.newNode(n);
            } else {
                bl = true;
                n2 += 2;
            }
            switch (n2) {
                case 0: {
                    if (bl) {
                        return Integer.toString(morphInterpretation.getStartNode());
                    }
                    return null;
                }
                case 1: {
                    if (bl) {
                        return Integer.toString(morphInterpretation.getEndNode());
                    }
                    return null;
                }
                case 2: {
                    if (bl) {
                        String string = morphInterpretation.getOrth();
                        if (string.contains(" ")) {
                            string = string.replace(' ', '\u23b5');
                        }
                        return string;
                    }
                    return null;
                }
                case 3: {
                    return morphInterpretation.getLemma();
                }
                case 4: {
                    return morphInterpretation.getTag(ResultsPane.this.controller.getMorfeusz());
                }
                case 5: {
                    return morphInterpretation.getName(ResultsPane.this.controller.getMorfeusz());
                }
                case 6: {
                    Collection<String> collection = morphInterpretation.getLabels(ResultsPane.this.controller.getMorfeusz());
                    Object object = null;
                    boolean bl2 = false;
                    if (collection.size() > 0) {
                        object = "[";
                        for (String string : collection) {
                            if (bl2) {
                                object = (String)object + "; ";
                            }
                            object = (String)object + string;
                            bl2 = true;
                        }
                        object = (String)object + "]";
                    }
                    return object;
                }
            }
            return null;
        }
    }
}

