/*
 * Decompiled with CFR 0.152.
 */
package morfeusz;

import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import morfeusz.Morfeusz;
import morfeusz.Preferences;
import pl.sgjp.morfeusz.MorfeuszUsage;
import pl.sgjp.morfeusz.MorphInterpretation;

public class Agent {
    private Morfeusz controller;
    private String textToAnalyze;
    private String lemma;
    private String dictionary;
    private HashSet<Integer> interpBoundaries;
    private List<MorphInterpretation> analyzeResults;
    private List<MorphInterpretation> generateResults;
    private pl.sgjp.morfeusz.Morfeusz morfeusz;

    public static Agent createAgent(Morfeusz morfeusz) {
        Agent agent = new Agent(morfeusz);
        if (agent.morfeusz == null) {
            return null;
        }
        return agent;
    }

    public Agent(Morfeusz morfeusz) {
        this.controller = morfeusz;
        this.textToAnalyze = null;
        this.lemma = null;
        this.dictionary = null;
        this.interpBoundaries = null;
        this.analyzeResults = null;
        this.generateResults = null;
        this.initializeWithDictionaryName();
    }

    public void initialize() {
        Preferences preferences = this.controller.getPreferences();
        this.morfeusz.setAggl(preferences.aggl);
        this.morfeusz.setPraet(preferences.praet);
        this.morfeusz.setCaseHandling(preferences.caseHandling);
        this.morfeusz.setWhitespaceHandling(preferences.whitespaceHandling);
        this.morfeusz.setTokenNumbering(preferences.tokenNumbering);
    }

    public void initializeWithDictionaryName() {
        Preferences preferences = this.controller.getPreferences();
        this.morfeusz = null;
        if (preferences.dictionary != null) {
            File file = new File(preferences.dictionary);
            if (file.exists()) {
                try {
                    this.morfeusz = pl.sgjp.morfeusz.Morfeusz.createInstance(preferences.dictionary, MorfeuszUsage.BOTH_ANALYSE_AND_GENERATE);
                }
                catch (Exception exception) {
                    this.morfeusz = null;
                    preferences.dictionary = null;
                }
            } else {
                preferences.dictionary = null;
            }
        }
        if (this.morfeusz == null) {
            try {
                this.morfeusz = pl.sgjp.morfeusz.Morfeusz.createInstance(MorfeuszUsage.BOTH_ANALYSE_AND_GENERATE);
            }
            catch (Exception exception) {
                this.morfeusz = null;
            }
        }
        if (this.morfeusz != null) {
            this.initialize();
        } else {
            preferences.dictionary = null;
        }
    }

    public void setTextToAnalyze(String string) {
        this.textToAnalyze = string;
    }

    public void setLemma(String string) {
        this.lemma = string;
    }

    public void clearAnalyzeResults() {
        this.analyzeResults.clear();
        this.analyzeResults = null;
        this.interpBoundaries = null;
        this.textToAnalyze = null;
    }

    public void clearGenerateResults() {
        this.generateResults.clear();
        this.generateResults = null;
        this.lemma = null;
    }

    public HashSet<Integer> getInterpBoundaries() {
        return this.interpBoundaries;
    }

    public List<MorphInterpretation> getAnalyzeResults() {
        return this.analyzeResults;
    }

    public List<MorphInterpretation> getGenerateResults() {
        return this.generateResults;
    }

    public boolean hasAnalyzeResults() {
        if (this.analyzeResults == null) {
            return false;
        }
        return !this.analyzeResults.isEmpty();
    }

    public boolean hasGenerateResults() {
        if (this.generateResults == null) {
            return false;
        }
        return !this.generateResults.isEmpty();
    }

    public boolean analyze() {
        this.analyzeResults = null;
        this.interpBoundaries = null;
        try {
            this.analyze(this.textToAnalyze);
        }
        catch (Exception exception) {
            this.analyzeResults = null;
            this.interpBoundaries = null;
            return false;
        }
        return true;
    }

    public void analyze(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            List<MorphInterpretation> list = this.morfeusz.analyseAsList(string2);
            if (this.analyzeResults == null) {
                this.analyzeResults = list;
                this.interpBoundaries = new HashSet();
            } else {
                this.analyzeResults.addAll(list);
            }
            this.interpBoundaries.add(this.analyzeResults.size());
        }
    }

    public boolean generate() {
        this.generateResults = null;
        try {
            this.generateResults = this.morfeusz.generate(this.lemma);
        }
        catch (Exception exception) {
            this.generateResults = null;
            return false;
        }
        return true;
    }

    public boolean setDictionary(String string) {
        pl.sgjp.morfeusz.Morfeusz morfeusz = this.morfeusz;
        try {
            if (string == null) {
                if (this.dictionary != null) {
                    this.morfeusz = pl.sgjp.morfeusz.Morfeusz.createInstance(MorfeuszUsage.BOTH_ANALYSE_AND_GENERATE);
                    this.initialize();
                }
            } else {
                this.morfeusz = pl.sgjp.morfeusz.Morfeusz.createInstance(string, MorfeuszUsage.BOTH_ANALYSE_AND_GENERATE);
                this.initialize();
            }
            this.dictionary = string;
        }
        catch (Exception exception) {
            this.morfeusz = morfeusz;
            return false;
        }
        return true;
    }

    public void saveAnalyzeResults(PrintWriter printWriter) {
        if (this.hasAnalyzeResults()) {
            for (int i = 0; i < this.analyzeResults.size(); ++i) {
                MorphInterpretation morphInterpretation = this.analyzeResults.get(i);
                printWriter.print("[");
                printWriter.print(Integer.toString(morphInterpretation.getStartNode()));
                printWriter.print(", ");
                printWriter.print(Integer.toString(morphInterpretation.getEndNode()));
                printWriter.print(", ");
                printWriter.print(morphInterpretation.getOrth());
                printWriter.print(", ");
                printWriter.print(morphInterpretation.getLemma());
                printWriter.print(", ");
                printWriter.print(morphInterpretation.getTag(this.morfeusz));
                printWriter.print(", ");
                printWriter.print(morphInterpretation.getName(this.morfeusz));
                printWriter.print(", ");
                Collection<String> collection = morphInterpretation.getLabels(this.controller.getMorfeusz());
                Object object = null;
                boolean bl = false;
                if (collection.size() > 0) {
                    object = "";
                    for (String string : collection) {
                        if (bl) {
                            object = (String)object + "; ";
                        }
                        object = (String)object + string;
                        bl = true;
                    }
                }
                printWriter.print((String)object);
                printWriter.println("]");
            }
        }
    }

    public void saveGenerateResults(PrintWriter printWriter) {
        if (this.hasAnalyzeResults()) {
            for (int i = 0; i < this.generateResults.size(); ++i) {
                MorphInterpretation morphInterpretation = this.generateResults.get(i);
                printWriter.print("[");
                printWriter.print(morphInterpretation.getOrth());
                printWriter.print(", ");
                printWriter.print(morphInterpretation.getLemma());
                printWriter.print(", ");
                printWriter.print(morphInterpretation.getTag(this.morfeusz));
                printWriter.print(", ");
                printWriter.print(morphInterpretation.getName(this.morfeusz));
                printWriter.print(", ");
                printWriter.print(morphInterpretation.getName(this.morfeusz));
                printWriter.print(", ");
                Collection<String> collection = morphInterpretation.getLabels(this.controller.getMorfeusz());
                Object object = null;
                boolean bl = false;
                if (collection.size() > 0) {
                    object = "";
                    for (String string : collection) {
                        if (bl) {
                            object = (String)object + "; ";
                        }
                        object = (String)object + string;
                        bl = true;
                    }
                }
                printWriter.print((String)object);
                printWriter.println("]");
            }
        }
    }

    public pl.sgjp.morfeusz.Morfeusz getMorfeusz() {
        return this.morfeusz;
    }
}

