/*
 * Decompiled with CFR 0.152.
 */
package morfeusz;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class DictSearchPathsDialog
extends JPanel {
    private JDialog dialog;
    private PathList pathList;
    private JButton acceptButton;
    private JButton cancelButton;
    private JButton addButton;
    private JButton removeButton;
    private JButton defaultsButton;
    private List<String> searchPaths;
    private List<String> defaultSearchPaths;
    private int ret;

    public DictSearchPathsDialog(List<String> list, List<String> list2) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        this.setPreferredSize(new Dimension(600, 200));
        this.searchPaths = list;
        this.defaultSearchPaths = list2;
        this.arrangeComponents();
    }

    public void arrangeComponents() {
        JLabel jLabel = new JLabel("\u015acie\u017cka wyszukiwania s\u0142ownik\u00f3w:");
        Box box = Box.createHorizontalBox();
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        this.add((Component)jLabel, "North");
        this.pathList = new PathList();
        JScrollPane jScrollPane = new JScrollPane(this.pathList);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jScrollPane.getViewport().setBackground(Color.white);
        this.add((Component)jScrollPane, "Center");
        this.addButton = new JButton("Dodaj");
        this.removeButton = new JButton("Usu\u0144");
        this.defaultsButton = new JButton("Domy\u015blna");
        this.cancelButton = new JButton("Anuluj");
        this.acceptButton = new JButton("Akceptuj");
        Dimension dimension = this.defaultsButton.getPreferredSize();
        this.addButton.setPreferredSize(dimension);
        this.removeButton.setPreferredSize(dimension);
        this.cancelButton.setPreferredSize(dimension);
        this.acceptButton.setPreferredSize(dimension);
        box.setBorder(BorderFactory.createEmptyBorder(16, 0, 0, 0));
        box.add(this.addButton);
        box.add(Box.createHorizontalStrut(8));
        box.add(this.removeButton);
        box.add(Box.createHorizontalStrut(8));
        box.add(Box.createHorizontalGlue());
        box.add(this.defaultsButton);
        box.add(Box.createHorizontalGlue());
        box.add(Box.createHorizontalStrut(8));
        box.add(this.cancelButton);
        box.add(Box.createHorizontalStrut(8));
        box.add(this.acceptButton);
        this.add((Component)box, "South");
        this.removeButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DictSearchPathsDialog.this.addPath();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DictSearchPathsDialog.this.removePath();
            }
        });
        this.defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DictSearchPathsDialog.this.defaults();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DictSearchPathsDialog.this.dialog.setVisible(false);
            }
        });
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DictSearchPathsDialog.this.modifySearchPaths();
                DictSearchPathsDialog.this.ret = 1;
                DictSearchPathsDialog.this.dialog.setVisible(false);
            }
        });
    }

    public void addPath() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Select Files");
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(true);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.pathList.getModel();
            Object[] objectArray = new Object[1];
            for (int i = 0; i < fileArray.length; ++i) {
                objectArray[0] = fileArray[i].getPath();
                defaultTableModel.addRow(objectArray);
            }
        }
    }

    public void removePath() {
        int[] nArray = this.pathList.getSelectedRows();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.pathList.getModel();
        for (int i = 0; i < nArray.length; ++i) {
            defaultTableModel.removeRow(nArray[i] - i);
        }
    }

    public void defaults() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.pathList.getModel();
        int n = defaultTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            defaultTableModel.removeRow(0);
        }
        if (this.defaultSearchPaths != null && !this.defaultSearchPaths.isEmpty()) {
            Object[] objectArray = new Object[1];
            for (String string : this.defaultSearchPaths) {
                objectArray[0] = string;
                defaultTableModel.addRow(objectArray);
            }
        }
    }

    public void modifySearchPaths() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.pathList.getModel();
        int n = defaultTableModel.getRowCount();
        this.searchPaths.clear();
        for (int i = 0; i < n; ++i) {
            String string = (String)defaultTableModel.getValueAt(i, 0);
            this.searchPaths.add(string);
        }
    }

    public int doDialog() {
        this.ret = 0;
        this.dialog = new JDialog();
        this.dialog.setModal(true);
        this.dialog.setDefaultCloseOperation(1);
        this.dialog.setTitle("Ustawianie \u015bcie\u017cki wyszukiwania s\u0142ownik\u00f3w");
        this.dialog.setResizable(true);
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
        return this.ret;
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    private class PathListTransferHandler
    extends TransferHandler {
        private boolean canImport = false;
        private boolean accept = false;
        private int[] rows = null;
        private int addIndex = -1;
        private int addCount = 0;

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            this.accept = true;
            return new StringSelection(this.exportString(jComponent));
        }

        protected String exportString(JComponent jComponent) {
            JTable jTable = (JTable)jComponent;
            StringBuffer stringBuffer = new StringBuffer();
            this.rows = jTable.getSelectedRows();
            for (int i = 0; i < this.rows.length; ++i) {
                String string = (String)jTable.getValueAt(this.rows[i], 0);
                stringBuffer.append(string);
                if (i == this.rows.length - 1) continue;
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }

        protected void importString(JComponent jComponent, String string) {
            JTable jTable = (JTable)jComponent;
            DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
            int n = jTable.getSelectedRow();
            if (this.rows != null && n >= this.rows[0] - 1 && n <= this.rows[this.rows.length - 1]) {
                this.rows = null;
                return;
            }
            int n2 = defaultTableModel.getRowCount();
            if (n < 0) {
                n = n2;
            } else if (++n > n2) {
                n = n2;
            }
            this.addIndex = n;
            String[] stringArray = string.split("\n");
            this.addCount = stringArray.length;
            for (int i = 0; i < stringArray.length; ++i) {
                Object[] objectArray = new Object[]{stringArray[i]};
                defaultTableModel.insertRow(n++, objectArray);
            }
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                this.canImport = true;
                try {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    this.importString(jComponent, string);
                    return true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (this.canImport) {
                JTable jTable = (JTable)jComponent;
                if (this.rows != null) {
                    int n2;
                    DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
                    if (this.addCount > 0) {
                        for (n2 = 0; n2 < this.rows.length; ++n2) {
                            if (this.rows[n2] <= this.addIndex) continue;
                            int n3 = n2;
                            this.rows[n3] = this.rows[n3] + this.addCount;
                        }
                    }
                    for (n2 = this.rows.length - 1; n2 >= 0; --n2) {
                        defaultTableModel.removeRow(this.rows[n2]);
                    }
                }
                this.rows = null;
                this.addCount = 0;
                this.addIndex = -1;
                this.canImport = false;
            }
            this.accept = false;
        }

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            if (this.accept) {
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    if (!DataFlavor.stringFlavor.equals(dataFlavorArray[i])) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class PathListModel
    extends DefaultTableModel {
        public PathListModel() {
            super(0, 1);
        }

        public Class<? extends Object> getColumnClass(int n) {
            Vector vector = this.getDataVector().elementAt(0);
            return vector.elementAt(n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    private class PathList
    extends JTable {
        public PathList() {
            super(new PathListModel());
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setBackground(Color.white);
            this.setTableHeader(null);
            this.setRowSelectionAllowed(true);
            this.setDragEnabled(true);
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(false);
            this.setTransferHandler(new PathListTransferHandler());
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    DictSearchPathsDialog.this.removeButton.setEnabled(PathList.this.getSelectedRowCount() > 0);
                }
            });
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
            Object[] objectArray = new Object[1];
            for (String string : DictSearchPathsDialog.this.searchPaths) {
                objectArray[0] = string;
                defaultTableModel.addRow(objectArray);
            }
        }
    }
}

