/*
 * Decompiled with CFR 0.152.
 */
package morfeusz;

import java.awt.Insets;
import java.net.URL;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ToolBarButton
extends JButton {
    private String iconName;

    public ToolBarButton(Action action, String string) {
        super(action);
        this.setText(null);
        this.iconName = string;
        this.initButton();
    }

    private void initButton() {
        ImageIcon imageIcon;
        this.setRolloverEnabled(true);
        this.setRequestFocusEnabled(false);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        URL uRL = ClassLoader.getSystemClassLoader().getResource(this.iconName + ".png");
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL);
            this.setIcon(imageIcon);
        }
        if ((uRL = ClassLoader.getSystemClassLoader().getResource(this.iconName + "_disabled.png")) != null) {
            imageIcon = new ImageIcon(uRL);
            this.setDisabledIcon(imageIcon);
        }
        if ((uRL = ClassLoader.getSystemClassLoader().getResource(this.iconName + "_roll_over.png")) != null) {
            imageIcon = new ImageIcon(uRL);
            this.setRolloverIcon(imageIcon);
        }
        if ((uRL = ClassLoader.getSystemClassLoader().getResource(this.iconName + "_pressed.png")) != null) {
            imageIcon = new ImageIcon(uRL);
            this.setPressedIcon(imageIcon);
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return this.isRequestFocusEnabled();
    }
}

