/*
 * Decompiled with CFR 0.152.
 */
package morfeusz;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.Normalizer;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import morfeusz.AboutDialog;
import morfeusz.Agent;
import morfeusz.DictSearchPathsDialog;
import morfeusz.OptionsDialog;
import morfeusz.PlaceHolder;
import morfeusz.Preferences;
import morfeusz.RecentFileAction;
import morfeusz.ResultsPane;
import morfeusz.SelectFileDialog;
import morfeusz.ToolBarButton;
import quitaboutpreferenceshandler.QuitAboutPreferencesHandler;

public class Morfeusz
extends JFrame {
    public static final String WINDOW_TITLE = "Analizator Morfologiczny Morfeusz";
    public static final String STANDARD = "Standardowy (" + pl.sgjp.morfeusz.Morfeusz.getDefaultDictName() + ")";
    public static final String DICT_MESSAGE = "<html>Wyst\u0105pi\u0142 b\u0142\u0105d przy pr\u00f3bie zamiany s\u0142ownika.<br/>S\u0142ownik nie zosta\u0142 zmieniony.</html>";
    public static final String NATIVE_ERROR_MESSAGE = "Wyst\u0105pi\u0142 nieznany b\u0142\u0105d";
    public static final Color LIGHT_GRAY = new Color(240, 240, 240);
    public static final Color VLIGHT_BLUE = new Color(237, 243, 254);
    public static final Font FONT = new Font("SansSerif", 0, 10);
    public static final int NUM_OF_FONT_SIZES = 10;
    private static boolean isMacOS;
    public static Font plainFont;
    public static Font boldFont;
    public static Font italicFont;
    private List<String> defaultSearchPaths;
    private List<String> dictSearchPaths;
    private List<String> dictionaries;
    private Agent agent;
    private Preferences preferences;
    private JTabbedPane tabbedPane;
    private AnalyzeView analyzeView;
    private GenerateView generateView;
    private JTextArea textPane;
    private JTextField lemmaField;
    private ResultsPane analyzePane;
    private ResultsPane generatePane;
    private Action exitAction;
    private Action aboutAction;
    private Action optionsAction;
    private Action resetAction;
    private Action analyzeAction;
    private Action generateAction;
    private Action openAction;
    private Action saveActionA;
    private Action saveActionG;
    private Action changeAction;
    private Action changeToStandardAction;
    private Action editAction;
    private Action increaseFontAction;
    private Action decreaseFontAction;
    private Action insertNewLineAction;
    private JButton exitButton;
    private JButton resetButton;
    private JButton actionButton;
    private ToolBarButton returnButton;
    private ToolBarButton openButton;
    private ToolBarButton saveButtonA;
    private ToolBarButton saveButtonG;
    private ToolBarButton changeButtonA;
    private ToolBarButton changeButtonG;
    private ToolBarButton aboutButton;
    private ToolBarButton optionsButton;
    private ToolBarButton increaseFontButton;
    private ToolBarButton decreaseFontButton;
    private JCheckBox appendCheckBoxA;
    private JCheckBox appendCheckBoxG;
    private JPopupMenu changePopup;
    private JLabel analyzeDictionaryName;
    private JLabel generateDictionaryName;
    private File inputFile;
    private File outputFile;
    private DictFilter filter;
    private String dictionary;
    private boolean analyze;
    private Rectangle topLeft = new Rectangle(0, 0, 0, 0);

    public Morfeusz() {
        String string = System.getProperty("os.name");
        if (string != null && string.contains("Mac OS X")) {
            new QuitAboutPreferencesHandler(){

                @Override
                public void handleQuitRequest() {
                    Morfeusz.this.exit();
                }

                @Override
                public void handleAboutRequest() {
                    Morfeusz.this.about();
                }

                @Override
                public void handlePreferencesRequest() {
                    Morfeusz.this.options();
                }
            };
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            isMacOS = true;
        } else {
            isMacOS = false;
        }
        this.readPreferences();
        plainFont = FONT.deriveFont(0, this.preferences.fontSize + 10);
        boldFont = FONT.deriveFont(1, this.preferences.fontSize + 10);
        italicFont = FONT.deriveFont(2, this.preferences.fontSize + 10);
        this.initialize();
        this.agent = Agent.createAgent(this);
        if (this.agent == null) {
            JOptionPane.showMessageDialog(null, NATIVE_ERROR_MESSAGE, "Uwaga", 0);
            this.exit();
        }
        this.setDefaultCloseOperation(0);
        this.setTitle(WINDOW_TITLE);
        this.setSizeAndPosition();
        this.arrangeComponents();
        this.getRootPane().setDefaultButton(this.actionButton);
        this.checkComponents();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Morfeusz.this.exit();
            }
        });
    }

    public void initialize() {
        this.openAction = new AbstractAction("Czytaj z pliku"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Morfeusz.this.open();
            }
        };
        this.optionsAction = new AbstractAction("Opcje programu"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Morfeusz.this.options();
            }
        };
        this.saveActionA = new AbstractAction("Zapisz Wyniki Analizy"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Morfeusz.this.save();
            }
        };
        this.saveActionG = new AbstractAction("Zapisz Wygenerowane Formy"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Morfeusz.this.save();
            }
        };
        this.changeToStandardAction = new AbstractAction("S\u0142ownik Standardowy"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Morfeusz.this.changeToStandardDictionary();
            }
        };
        this.changeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Morfeusz.this.changeDictionary();
            }
        };
        this.editAction = new AbstractAction("Ustaw \u015acie\u017ck\u0119 Wyszukiwania S\u0142ownik\u00f3w..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Morfeusz.this.editDictSearchPaths();
            }
        };
        this.exitAction = new AbstractAction("Zako\u0144cz"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Morfeusz.this.exit();
            }
        };
        this.aboutAction = new AbstractAction("About"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Morfeusz.this.about();
            }
        };
        this.increaseFontAction = new AbstractAction("Powi\u0119ksz czcionk\u0119"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Morfeusz.this.changeFontSize(true);
            }
        };
        this.decreaseFontAction = new AbstractAction("Zmniejsz czcionk\u0119"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Morfeusz.this.changeFontSize(false);
            }
        };
        this.resetAction = new AbstractAction("Wyczy\u015b\u0107"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Morfeusz.this.reset();
            }
        };
        this.analyzeAction = new AbstractAction("Analizuj"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Morfeusz.this.analyze();
            }
        };
        this.generateAction = new AbstractAction("Generuj"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Morfeusz.this.generate();
            }
        };
        this.insertNewLineAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Morfeusz.this.insertNewLine();
            }
        };
        this.filter = new DictFilter();
        this.dictSearchPaths = pl.sgjp.morfeusz.Morfeusz.getDictionarySearchPaths();
        this.defaultSearchPaths = new LinkedList<String>();
        for (String object : this.dictSearchPaths) {
            this.defaultSearchPaths.add(object);
        }
        if (this.preferences.dictPaths != null) {
            this.dictSearchPaths.clear();
            for (String string : this.preferences.dictPaths) {
                this.dictSearchPaths.add(string);
            }
        } else if (this.dictSearchPaths.size() > 0) {
            int n = 0;
            this.preferences.dictPaths = new String[this.dictSearchPaths.size()];
            for (String string : this.dictSearchPaths) {
                this.preferences.dictPaths[n++] = string;
            }
        }
        this.getDictionaries();
        this.dictionary = this.preferences.dictionary == null ? STANDARD : this.preferences.dictionary;
        if (!this.dictionaries.contains(this.dictionary)) {
            this.dictionary = STANDARD;
        }
        this.analyze = true;
    }

    public void getDictionaries() {
        Object object;
        this.dictionaries = new LinkedList<String>();
        if (this.dictSearchPaths.size() > 0) {
            ListIterator<String> listIterator = this.dictSearchPaths.listIterator();
            while (listIterator.hasNext()) {
                object = listIterator.next();
                File object2 = new File((String)object);
                if (!object2.exists()) continue;
                this.addDictionaries(object2);
            }
        } else {
            object = new File(System.getProperty("user.dir"));
            this.addDictionaries((File)object);
        }
        this.changePopup = new JPopupMenu();
        this.changePopup.add(this.changeToStandardAction);
        this.changePopup.addSeparator();
        if (!this.dictionaries.isEmpty()) {
            for (String string : this.dictionaries) {
                this.changePopup.add(new RecentFileAction(string, this));
            }
            this.changePopup.addSeparator();
        }
        this.changePopup.add(this.editAction);
    }

    public void addDictionaries(File file) {
        String[] stringArray;
        for (String string : stringArray = file.list(this.filter)) {
            int n = string.lastIndexOf("-");
            if (this.dictionaries.contains(string = string.substring(0, n))) continue;
            this.dictionaries.add(string);
        }
    }

    public void setSizeAndPosition() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Insets insets = toolkit.getScreenInsets(graphicsConfiguration);
        Rectangle rectangle = new Rectangle();
        rectangle.x = (dimension.width - insets.left - insets.right) / 4;
        rectangle.y = (dimension.height - insets.top - insets.bottom) / 8;
        rectangle.width = 2 * rectangle.x;
        rectangle.height = 6 * rectangle.y;
        this.setBounds(rectangle);
    }

    public void arrangeComponents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        this.tabbedPane = new JTabbedPane();
        this.analyzeView = new AnalyzeView();
        this.generateView = new GenerateView();
        this.tabbedPane.setFocusable(false);
        this.tabbedPane.addTab("Analizator", this.analyzeView);
        this.tabbedPane.addTab("Generator", this.generateView);
        jPanel.add((Component)this.tabbedPane, "Center");
        this.exitButton = new JButton(this.exitAction);
        this.resetButton = new JButton(this.resetAction);
        this.actionButton = new JButton(this.analyzeAction);
        this.aboutButton = new ToolBarButton(this.aboutAction, "info");
        this.aboutButton.setToolTipText("Informacje o programie.");
        this.optionsButton = new ToolBarButton(this.optionsAction, "conf");
        this.optionsButton.setToolTipText("Parametry programu.");
        this.increaseFontButton = new ToolBarButton(this.increaseFontAction, "font_increase");
        this.increaseFontButton.setToolTipText("Powi\u0119ksz czcionk\u0119.");
        this.decreaseFontButton = new ToolBarButton(this.decreaseFontAction, "font_decrease");
        this.decreaseFontButton.setToolTipText("Zmniejsz czcionk\u0119.");
        this.increaseFontButton.setEnabled(this.preferences.fontSize < 9);
        this.decreaseFontButton.setEnabled(this.preferences.fontSize > 0);
        Box box = Box.createVerticalBox();
        if (!isMacOS) {
            box.add(Box.createVerticalStrut(16));
        }
        Box box2 = Box.createHorizontalBox();
        box2.add(this.aboutButton);
        box2.add(Box.createHorizontalStrut(8));
        box2.add(this.optionsButton);
        box2.add(Box.createHorizontalStrut(8));
        box2.add(this.increaseFontButton);
        box2.add(Box.createHorizontalStrut(8));
        box2.add(this.decreaseFontButton);
        box2.add(Box.createHorizontalStrut(8));
        box2.add(this.exitButton);
        box2.add(Box.createHorizontalStrut(8));
        box2.add(this.resetButton);
        box2.add(Box.createHorizontalGlue());
        box2.add(Box.createHorizontalStrut(8));
        box2.add(this.actionButton);
        box.add(box2);
        jPanel.add((Component)box, "South");
        this.getContentPane().add(jPanel);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = Morfeusz.this.tabbedPane.getSelectedIndex();
                if (n == 0) {
                    Morfeusz.this.actionButton.setAction(Morfeusz.this.analyzeAction);
                    Morfeusz.this.analyze = true;
                } else {
                    Morfeusz.this.actionButton.setAction(Morfeusz.this.generateAction);
                    Morfeusz.this.analyze = false;
                }
                Morfeusz.this.checkComponents();
            }
        });
    }

    public void open() {
        SelectFileDialog selectFileDialog = new SelectFileDialog((Frame)this, 0);
        selectFileDialog.setVisible(true);
        if (selectFileDialog.accept()) {
            this.inputFile = selectFileDialog.getSelectedFile();
            this.readText(this.inputFile, selectFileDialog.getEncoding());
        }
        selectFileDialog.dispose();
    }

    public void readText(File file, String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
            boolean bl = false;
            this.textPane.setText("");
            while ((string2 = bufferedReader.readLine()) != null) {
                if (bl) {
                    this.textPane.append("\n");
                }
                this.textPane.append(Normalizer.normalize(string2, Normalizer.Form.NFC));
                bl = true;
            }
            bufferedReader.close();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Morfeusz.this.textPane.scrollRectToVisible(Morfeusz.this.topLeft);
                }
            });
        }
        catch (Exception exception) {
            exception.getStackTrace();
        }
    }

    public void save() {
        boolean bl;
        boolean bl2 = true;
        boolean bl3 = bl = this.analyze ? this.appendCheckBoxA.isSelected() : this.appendCheckBoxG.isSelected();
        if (bl && this.outputFile != null && this.outputFile.exists()) {
            bl2 = false;
        }
        if (bl2) {
            SelectFileDialog selectFileDialog = new SelectFileDialog((Frame)this, 1);
            selectFileDialog.setSelectedFile(new File("Results.txt"));
            selectFileDialog.setVisible(true);
            if (selectFileDialog.accept()) {
                this.outputFile = selectFileDialog.getSelectedFile();
                this.save(this.outputFile, bl);
                this.appendCheckBoxA.setSelected(true);
            }
        } else {
            this.save(this.outputFile, bl);
        }
    }

    public void save(File file, boolean bl) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file, bl), "UTF8");
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            PrintWriter printWriter = new PrintWriter(bufferedWriter);
            if (bl) {
                printWriter.println();
            }
            if (this.analyze) {
                this.agent.saveAnalyzeResults(printWriter);
            } else {
                this.agent.saveGenerateResults(printWriter);
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            exception.getStackTrace();
        }
    }

    public void changeDictionaryName(String string) {
        this.dictionary = string;
        if (string.equals(STANDARD)) {
            this.analyzeDictionaryName.setText(string);
            this.analyzeDictionaryName.setForeground(Color.gray);
            this.generateDictionaryName.setText(string);
            this.generateDictionaryName.setForeground(Color.gray);
        } else {
            this.analyzeDictionaryName.setText(string);
            this.analyzeDictionaryName.setForeground(Color.black);
            this.generateDictionaryName.setText(string);
            this.generateDictionaryName.setForeground(Color.black);
        }
    }

    public void changeToStandardDictionary() {
        this.preferences.dictionary = null;
        this.agent.setDictionary(null);
        this.refreshAnalyzeResults();
        this.refreshGenerateResults();
        this.changeDictionaryName(STANDARD);
    }

    public void changeDictionary() {
        if (this.analyze) {
            this.changePopup.show(this.changeButtonA, 0, 0);
        } else {
            this.changePopup.show(this.changeButtonG, 0, 0);
        }
    }

    public void changeDictionary(String string) {
        if (this.agent.setDictionary(string)) {
            this.preferences.dictionary = string;
            this.changeDictionaryName(string);
            this.refreshAnalyzeResults();
            this.refreshGenerateResults();
        } else {
            JOptionPane.showMessageDialog(null, DICT_MESSAGE, "Uwaga", 0);
            this.removeFromChangePopup(string);
        }
    }

    public void removeFromChangePopup(String string) {
        JMenuItem jMenuItem = null;
        int n = this.changePopup.getComponentCount() - 2;
        for (int i = 2; i < n; ++i) {
            JMenuItem jMenuItem2 = (JMenuItem)this.changePopup.getComponent(i);
            RecentFileAction recentFileAction = (RecentFileAction)jMenuItem2.getAction();
            if (!recentFileAction.getName().equals(string)) continue;
            jMenuItem = jMenuItem2;
            break;
        }
        if (jMenuItem != null) {
            this.changePopup.remove(jMenuItem);
            if (n == 3) {
                this.changePopup.remove(2);
            }
        }
    }

    public void exit() {
        this.savePreferences();
        System.exit(0);
    }

    public void insertNewLine() {
        this.textPane.insert("\n", this.textPane.getCaretPosition());
    }

    public void options() {
        OptionsDialog optionsDialog = new OptionsDialog(this);
        if (optionsDialog.doDialog() != 0) {
            optionsDialog.transfer(this.preferences);
            this.agent.initialize();
            this.refreshAnalyzeResults();
            this.refreshGenerateResults();
        }
        optionsDialog.dispose();
    }

    public void editDictSearchPaths() {
        DictSearchPathsDialog dictSearchPathsDialog = new DictSearchPathsDialog(this.dictSearchPaths, this.defaultSearchPaths);
        if (dictSearchPathsDialog.doDialog() != 0) {
            this.getDictionaries();
            this.preferences.dictPaths = null;
            if (this.dictSearchPaths.size() > 0) {
                int n = 0;
                this.preferences.dictPaths = new String[this.dictSearchPaths.size()];
                for (String string : this.dictSearchPaths) {
                    this.preferences.dictPaths[n++] = string;
                }
            }
        }
        dictSearchPathsDialog.dispose();
    }

    public void readPreferences() {
        String string = System.getProperty("user.home") + File.separator + ".morfeuszGUI";
        File file = new File(string);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.preferences = (Preferences)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            this.preferences = new Preferences();
            this.preferences.setDefaults();
        }
    }

    public void savePreferences() {
        String string = System.getProperty("user.home") + File.separator + ".morfeuszGUI";
        File file = new File(string);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(this.preferences);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public void about() {
        AboutDialog aboutDialog = new AboutDialog(this.agent.getMorfeusz());
        aboutDialog.doDialog();
    }

    public void changeFontSize(boolean bl) {
        this.preferences.fontSize = bl ? ++this.preferences.fontSize : --this.preferences.fontSize;
        this.increaseFontButton.setEnabled(this.preferences.fontSize < 9);
        this.decreaseFontButton.setEnabled(this.preferences.fontSize > 0);
        plainFont = new Font(plainFont.getFontName(), plainFont.getStyle(), this.preferences.fontSize + 10);
        boldFont = new Font(boldFont.getFontName(), boldFont.getStyle(), this.preferences.fontSize + 10);
        italicFont = new Font(italicFont.getFontName(), italicFont.getStyle(), this.preferences.fontSize + 10);
        this.textPane.setFont(plainFont);
        this.analyzeView.changeFont();
        this.generateView.changeFont();
    }

    public pl.sgjp.morfeusz.Morfeusz getMorfeusz() {
        if (this.agent != null) {
            return this.agent.getMorfeusz();
        }
        return null;
    }

    public void reset() {
        if (this.analyze) {
            this.textPane.setText(null);
            this.textPane.requestFocusInWindow();
            this.analyzePane.showColumns(false);
            this.agent.clearAnalyzeResults();
        } else {
            this.lemmaField.setText(null);
            this.lemmaField.requestFocusInWindow();
            this.generatePane.showColumns(false);
            this.agent.clearGenerateResults();
        }
        this.checkComponents();
        System.gc();
    }

    public void analyze() {
        this.agent.setTextToAnalyze(this.textPane.getText());
        if (this.agent.analyze()) {
            if (this.agent.hasAnalyzeResults()) {
                this.analyzePane.setResults(this.agent.getAnalyzeResults(), this.agent.getInterpBoundaries());
                this.analyzePane.scrollRectToVisible(this.topLeft);
            } else {
                this.analyzePane.setResults(null, null);
            }
            this.checkComponents();
        } else {
            JOptionPane.showMessageDialog(null, NATIVE_ERROR_MESSAGE, "Uwaga", 0);
            this.analyzePane.showColumns(false);
            this.agent.clearAnalyzeResults();
        }
        System.gc();
    }

    public void refreshAnalyzeResults() {
        if (this.agent.hasAnalyzeResults()) {
            if (this.agent.analyze()) {
                if (this.agent.hasAnalyzeResults()) {
                    this.analyzePane.setResults(this.agent.getAnalyzeResults(), this.agent.getInterpBoundaries());
                    this.analyzePane.scrollRectToVisible(this.topLeft);
                } else {
                    this.analyzePane.setResults(null, null);
                }
                this.checkComponents();
            } else {
                JOptionPane.showMessageDialog(null, NATIVE_ERROR_MESSAGE, "Uwaga", 0);
                this.analyzePane.showColumns(false);
                this.agent.clearAnalyzeResults();
            }
            System.gc();
        }
    }

    public void generate() {
        String string = this.lemmaField.getText();
        string = string.trim();
        String[] stringArray = string.split(" ");
        string = stringArray[0];
        this.lemmaField.setText(string);
        this.agent.setLemma(this.lemmaField.getText());
        if (this.agent.generate()) {
            if (this.agent.hasGenerateResults()) {
                this.generatePane.setResults(this.agent.getGenerateResults(), null);
                this.generatePane.scrollRectToVisible(this.topLeft);
            } else {
                this.generatePane.setResults(null, null);
            }
            this.checkComponents();
        } else {
            JOptionPane.showMessageDialog(null, NATIVE_ERROR_MESSAGE, "Uwaga", 0);
            this.generatePane.showColumns(false);
            this.agent.clearGenerateResults();
        }
        System.gc();
    }

    public void refreshGenerateResults() {
        if (this.agent.hasGenerateResults()) {
            if (this.agent.generate()) {
                if (this.agent.hasGenerateResults()) {
                    this.generatePane.setResults(this.agent.getGenerateResults(), null);
                    this.generatePane.scrollRectToVisible(this.topLeft);
                } else {
                    this.generatePane.setResults(null, null);
                }
                this.checkComponents();
            } else {
                JOptionPane.showMessageDialog(null, NATIVE_ERROR_MESSAGE, "Uwaga", 0);
                this.generatePane.showColumns(false);
                this.agent.clearGenerateResults();
            }
            System.gc();
        }
    }

    public void checkComponents() {
        boolean bl = this.analyze && this.textPane.getDocument().getLength() > 0;
        boolean bl2 = !this.analyze && this.lemmaField.getDocument().getLength() > 0;
        boolean bl3 = this.analyze && this.agent.hasAnalyzeResults();
        boolean bl4 = !this.analyze && this.agent.hasGenerateResults();
        this.analyzeAction.setEnabled(bl);
        this.generateAction.setEnabled(bl2);
        this.saveActionA.setEnabled(bl3);
        this.saveActionG.setEnabled(bl4);
        this.resetAction.setEnabled(bl || bl2 || bl3 || bl4);
    }

    public static boolean isMacOS() {
        return isMacOS;
    }

    public static void main(String[] stringArray) {
        Morfeusz morfeusz = new Morfeusz();
        morfeusz.setVisible(true);
    }

    public class DictFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File file, String string) {
            return string.endsWith("-a.dict") || string.endsWith("-s.dict");
        }
    }

    private class GenerateView
    extends JPanel {
        public GenerateView() {
            super(new BorderLayout());
            this.arrangeComponents();
        }

        public void arrangeComponents() {
            int n = Morfeusz.isMacOS() ? -4 : -2;
            Box box = Box.createVerticalBox();
            Box box2 = Box.createHorizontalBox();
            box2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("S\u0142ownik:"), BorderFactory.createEmptyBorder(4, 4, 8, 4)));
            Morfeusz.this.generateDictionaryName = new JLabel(Morfeusz.this.dictionary);
            if (Morfeusz.this.dictionary.equals(STANDARD)) {
                Morfeusz.this.generateDictionaryName.setForeground(Color.gray);
            }
            box2.add(Morfeusz.this.generateDictionaryName);
            box2.add(Box.createHorizontalGlue());
            box2.add(Box.createHorizontalStrut(8));
            Morfeusz.this.changeButtonG = new ToolBarButton(Morfeusz.this.changeAction, "book_open");
            Morfeusz.this.changeButtonG.setFocusable(false);
            Morfeusz.this.changeButtonG.setToolTipText("Zmie\u0144 s\u0142ownik.");
            box2.add(Morfeusz.this.changeButtonG);
            box.add(box2);
            box.add(Box.createVerticalStrut(20));
            box2 = Box.createHorizontalBox();
            box.setBorder(BorderFactory.createEmptyBorder(16, 16, 8, 16));
            JLabel jLabel = new JLabel("Lemat:");
            box2.add(jLabel);
            box2.add(Box.createHorizontalStrut(8));
            Morfeusz.this.lemmaField = new JTextField(30);
            box2.add(Morfeusz.this.lemmaField);
            Dimension dimension = Morfeusz.this.lemmaField.getPreferredSize();
            Morfeusz.this.lemmaField.setMaximumSize(dimension);
            box2.add(Box.createHorizontalGlue());
            box.add(box2);
            this.add((Component)box, "North");
            box = Box.createVerticalBox();
            box.setBorder(BorderFactory.createEmptyBorder(8, 16, 16, 16));
            box2 = Box.createHorizontalBox();
            box2.setBorder(BorderFactory.createEmptyBorder(0, 0, n, 0));
            jLabel = new JLabel("Wygenerowane formy:");
            box2.add(jLabel);
            box2.add(Box.createHorizontalGlue());
            Morfeusz.this.appendCheckBoxG = new JCheckBox("Dopisz   ");
            Morfeusz.this.appendCheckBoxG.setFocusable(false);
            box2.add(Morfeusz.this.appendCheckBoxG);
            Morfeusz.this.saveButtonG = new ToolBarButton(Morfeusz.this.saveActionG, "save");
            Morfeusz.this.saveButtonG.setFocusable(false);
            Morfeusz.this.saveButtonG.setToolTipText("Zapisz wygenerowane formy wyrazowe do pliku.");
            box2.add(Morfeusz.this.saveButtonG);
            box.add(box2);
            PlaceHolder placeHolder = new PlaceHolder();
            Morfeusz.this.generatePane = new ResultsPane(false, Morfeusz.this, placeHolder);
            JScrollPane jScrollPane = new JScrollPane(Morfeusz.this.generatePane);
            jScrollPane.getViewport().setBackground(LIGHT_GRAY);
            jScrollPane.setCorner("UPPER_RIGHT_CORNER", placeHolder);
            box.add(jScrollPane);
            this.add((Component)box, "Center");
            Morfeusz.this.lemmaField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    Morfeusz.this.checkComponents();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    Morfeusz.this.checkComponents();
                }
            });
            Morfeusz.this.appendCheckBoxG.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Morfeusz.this.appendCheckBoxA.setSelected(Morfeusz.this.appendCheckBoxG.isSelected());
                }
            });
        }

        public void changeFont() {
            Morfeusz.this.generatePane.changeFont();
        }
    }

    private class AnalyzeView
    extends JPanel {
        public AnalyzeView() {
            super(new BorderLayout());
            this.arrangeComponents();
        }

        public void arrangeComponents() {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
            int n = Morfeusz.isMacOS() ? -4 : -2;
            Box box = Box.createVerticalBox();
            box.setBorder(BorderFactory.createEmptyBorder(16, 16, 8, 16));
            Box box2 = Box.createHorizontalBox();
            box2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("S\u0142ownik:"), BorderFactory.createEmptyBorder(4, 4, 8, 4)));
            Morfeusz.this.analyzeDictionaryName = new JLabel(Morfeusz.this.dictionary);
            if (Morfeusz.this.dictionary.equals(STANDARD)) {
                Morfeusz.this.analyzeDictionaryName.setForeground(Color.gray);
            }
            box2.add(Morfeusz.this.analyzeDictionaryName);
            box2.add(Box.createHorizontalGlue());
            box2.add(Box.createHorizontalStrut(8));
            Morfeusz.this.changeButtonA = new ToolBarButton(Morfeusz.this.changeAction, "book_open");
            Morfeusz.this.changeButtonA.setFocusable(false);
            Morfeusz.this.changeButtonA.setToolTipText("Zmie\u0144 s\u0142ownik.");
            box2.add(Morfeusz.this.changeButtonA);
            box.add(box2);
            box.add(Box.createVerticalStrut(16));
            box2 = Box.createHorizontalBox();
            box2.setBorder(BorderFactory.createEmptyBorder(0, 0, n, 0));
            JLabel jLabel = new JLabel("Tekst:");
            box2.add(jLabel);
            box2.add(Box.createHorizontalGlue());
            box2.add(Box.createHorizontalStrut(32));
            Morfeusz.this.returnButton = new ToolBarButton(Morfeusz.this.insertNewLineAction, "return");
            Morfeusz.this.returnButton.setFocusable(false);
            Morfeusz.this.returnButton.setToolTipText("Nowa linia.");
            box2.add(Morfeusz.this.returnButton);
            box2.add(Box.createHorizontalGlue());
            box2.add(Box.createHorizontalStrut(32));
            Morfeusz.this.openButton = new ToolBarButton(Morfeusz.this.openAction, "open");
            Morfeusz.this.openButton.setFocusable(false);
            Morfeusz.this.openButton.setToolTipText("Czytaj tekst z pliku.");
            box2.add(Morfeusz.this.openButton);
            box.add(box2);
            Morfeusz.this.textPane = new JTextArea();
            Morfeusz.this.textPane.setFont(plainFont);
            Morfeusz.this.textPane.setLineWrap(true);
            Morfeusz.this.textPane.setWrapStyleWord(true);
            Morfeusz.this.textPane.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            InputMap inputMap = Morfeusz.this.textPane.getInputMap();
            Morfeusz.this.textPane.getActionMap().put(inputMap.get(keyStroke), Morfeusz.this.analyzeAction);
            JScrollPane jScrollPane = new JScrollPane(Morfeusz.this.textPane);
            jScrollPane.setPreferredSize(new Dimension(0, 100));
            this.add(jScrollPane);
            box.add(jScrollPane);
            this.add((Component)box, "North");
            box = Box.createVerticalBox();
            box.setBorder(BorderFactory.createEmptyBorder(8, 16, 16, 16));
            box2 = Box.createHorizontalBox();
            box2.setBorder(BorderFactory.createEmptyBorder(0, 0, n, 0));
            jLabel = new JLabel("Analiza morfologiczna:");
            box2.add(jLabel);
            box2.add(Box.createHorizontalGlue());
            Morfeusz.this.appendCheckBoxA = new JCheckBox("Dopisz   ");
            Morfeusz.this.appendCheckBoxA.setFocusable(false);
            box2.add(Morfeusz.this.appendCheckBoxA);
            Morfeusz.this.saveButtonA = new ToolBarButton(Morfeusz.this.saveActionA, "save");
            Morfeusz.this.saveButtonA.setFocusable(false);
            Morfeusz.this.saveButtonA.setToolTipText("Zapisz wynik analizy do pliku.");
            box2.add(Morfeusz.this.saveButtonA);
            box.add(box2);
            PlaceHolder placeHolder = new PlaceHolder();
            Morfeusz.this.analyzePane = new ResultsPane(true, Morfeusz.this, placeHolder);
            jScrollPane = new JScrollPane(Morfeusz.this.analyzePane);
            jScrollPane.getViewport().setBackground(LIGHT_GRAY);
            jScrollPane.setCorner("UPPER_RIGHT_CORNER", placeHolder);
            box.add(jScrollPane);
            this.add((Component)box, "Center");
            Morfeusz.this.textPane.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    Morfeusz.this.checkComponents();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    Morfeusz.this.checkComponents();
                }
            });
            Morfeusz.this.appendCheckBoxA.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Morfeusz.this.appendCheckBoxG.setSelected(Morfeusz.this.appendCheckBoxA.isSelected());
                }
            });
        }

        public void changeFont() {
            Morfeusz.this.analyzePane.changeFont();
        }
    }
}

