/*
 * Decompiled with CFR 0.152.
 */
package morfeusz;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import morfeusz.Morfeusz;
import morfeusz.Preferences;
import pl.sgjp.morfeusz.CaseHandling;
import pl.sgjp.morfeusz.TokenNumbering;
import pl.sgjp.morfeusz.WhitespaceHandling;

public class OptionsDialog
extends JPanel {
    private JDialog dialog;
    private JButton acceptButton;
    private JButton cancelButton;
    private JButton defaultsButton;
    private JComboBox<String> agglCombo;
    private JComboBox<String> praetCombo;
    private JComboBox<String> caseCombo;
    private JComboBox<String> spaceCombo;
    private JComboBox<String> tokenCombo;
    private Morfeusz controller;
    private int ret;

    public OptionsDialog(Morfeusz morfeusz) {
        super(new BorderLayout());
        this.controller = morfeusz;
        this.arrangeComponents();
        this.initiateValues();
    }

    public void arrangeComponents() {
        JPanel jPanel = new JPanel();
        Box box = Box.createHorizontalBox();
        GroupLayout groupLayout = new GroupLayout(jPanel);
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        GroupLayout.SequentialGroup sequentialGroup2 = groupLayout.createSequentialGroup();
        this.acceptButton = new JButton("Akceptuj");
        this.cancelButton = new JButton("Anuluj");
        this.defaultsButton = new JButton("Warto\u015bci domy\u015blne");
        JLabel jLabel = new JLabel("aggl: ");
        JLabel jLabel2 = new JLabel("praet: ");
        JLabel jLabel3 = new JLabel("case-handling: ");
        JLabel jLabel4 = new JLabel("whitespace-handling: ");
        JLabel jLabel5 = new JLabel("token-numbering: ");
        this.agglCombo = new JComboBox();
        for (String string : this.controller.getMorfeusz().getAvailableAgglOptions()) {
            this.agglCombo.addItem(string);
        }
        this.praetCombo = new JComboBox();
        for (String string : this.controller.getMorfeusz().getAvailablePraetOptions()) {
            this.praetCombo.addItem(string);
        }
        this.caseCombo = new JComboBox();
        for (CaseHandling enum_ : CaseHandling.values()) {
            this.caseCombo.addItem(enum_.name());
        }
        this.spaceCombo = new JComboBox();
        for (Enum enum_ : WhitespaceHandling.values()) {
            this.spaceCombo.addItem(enum_.name());
        }
        this.tokenCombo = new JComboBox();
        for (Enum enum_ : TokenNumbering.values()) {
            this.tokenCombo.addItem(enum_.name());
        }
        if (!Morfeusz.isMacOS()) {
            groupLayout.setAutoCreateGaps(true);
            groupLayout.setAutoCreateContainerGaps(true);
        }
        jPanel.setLayout(groupLayout);
        sequentialGroup.addGroup(groupLayout.createParallelGroup().addComponent(jLabel).addComponent(jLabel2).addComponent(jLabel3).addComponent(jLabel4).addComponent(jLabel5));
        sequentialGroup.addGroup(groupLayout.createParallelGroup().addComponent(this.agglCombo).addComponent(this.praetCombo).addComponent(this.caseCombo).addComponent(this.spaceCombo).addComponent(this.tokenCombo));
        groupLayout.setHorizontalGroup(sequentialGroup);
        sequentialGroup2.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(this.agglCombo));
        sequentialGroup2.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.praetCombo));
        sequentialGroup2.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(this.caseCombo));
        sequentialGroup2.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel4).addComponent(this.spaceCombo));
        sequentialGroup2.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel5).addComponent(this.tokenCombo));
        groupLayout.setVerticalGroup(sequentialGroup2);
        box.setBorder(BorderFactory.createEmptyBorder(16, 0, 0, 0));
        box.add(this.defaultsButton);
        box.add(Box.createHorizontalStrut(8));
        box.add(Box.createHorizontalGlue());
        box.add(this.cancelButton);
        box.add(Box.createHorizontalStrut(8));
        box.add(this.acceptButton);
        Dimension dimension = this.acceptButton.getPreferredSize();
        this.cancelButton.setPreferredSize(dimension);
        this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        this.add((Component)jPanel, "Center");
        this.add((Component)box, "South");
        this.defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog.this.setDefaults();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog.this.dialog.setVisible(false);
            }
        });
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog.this.ret = 1;
                OptionsDialog.this.dialog.setVisible(false);
            }
        });
    }

    public void setDefaults() {
        Preferences preferences = new Preferences();
        preferences.setMorfeuszDefaults();
        this.initiateValues(preferences);
    }

    public void initiateValues() {
        this.initiateValues(this.controller.getPreferences());
    }

    public void initiateValues(Preferences preferences) {
        this.agglCombo.setSelectedItem(preferences.aggl);
        this.praetCombo.setSelectedItem(preferences.praet);
        this.caseCombo.setSelectedItem(preferences.caseHandling.name());
        this.spaceCombo.setSelectedItem(preferences.whitespaceHandling.name());
        this.tokenCombo.setSelectedItem(preferences.tokenNumbering.name());
    }

    public void transfer(Preferences preferences) {
        preferences.aggl = (String)this.agglCombo.getSelectedItem();
        preferences.praet = (String)this.praetCombo.getSelectedItem();
        preferences.caseHandling = CaseHandling.values()[this.caseCombo.getSelectedIndex()];
        preferences.whitespaceHandling = WhitespaceHandling.values()[this.spaceCombo.getSelectedIndex()];
        preferences.tokenNumbering = TokenNumbering.values()[this.tokenCombo.getSelectedIndex()];
    }

    public int doDialog() {
        this.ret = 0;
        this.dialog = new JDialog();
        this.dialog.setModal(true);
        this.dialog.setDefaultCloseOperation(1);
        this.dialog.setTitle("Opcje programu");
        this.dialog.setResizable(false);
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
        return this.ret;
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }
}

