/*
 * Decompiled with CFR 0.152.
 */
package morfeusz;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SelectFileDialog
extends JDialog {
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    private int mode;
    private boolean accepted;
    private JFileChooser fileChooser;
    private JComboBox<String> encodingsCombo;

    public SelectFileDialog(Frame frame, int n) {
        super(frame, true);
        this.mode = n;
        this.initDialog();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public void initDialog() {
        this.accepted = false;
        this.setPreferredSize(new Dimension(640, 480));
        this.fileChooser = new JFileChooser();
        this.fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectFileDialog.this.approveSelection(actionEvent.getActionCommand());
            }
        });
        if (this.mode == 0) {
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
            JPanel jPanel3 = new JPanel();
            this.setTitle("Select File");
            this.fileChooser.setDialogType(0);
            this.fileChooser.setApproveButtonText("Select");
            this.fileChooser.setApproveButtonMnemonic('S');
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Plain Text Files (*.txt)", "txt"));
            this.encodingsCombo = new JComboBox();
            this.encodingsCombo.addItem("UTF8 (Eight-bit Unicode Transformation Format)");
            this.encodingsCombo.addItem("Cp1250 (Windows Eastern European)");
            this.encodingsCombo.addItem("Cp852 (MS-DOS Latin-2)");
            this.encodingsCombo.addItem("Cp870 (IBM Multilingual Latin-2)");
            this.encodingsCombo.addItem("ISO-8859-2 (ISO 8859-2, Latin Alphabet No. 2)");
            this.encodingsCombo.addItem("MacCentralEurope (Macintosh Latin-2)");
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
            JLabel jLabel = new JLabel("Encoding: ");
            jPanel3.add(jLabel);
            jPanel3.add(this.encodingsCombo);
            jPanel2.add(jPanel3);
            jPanel.add((Component)this.fileChooser, "Center");
            jPanel.add((Component)jPanel2, "South");
            this.getContentPane().add(jPanel);
        } else {
            this.setTitle("Save Results");
            this.fileChooser.setDialogType(1);
            this.fileChooser.setApproveButtonText("Save");
            this.fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Plain Text Files (*.txt)", "txt"));
            this.getContentPane().add(this.fileChooser);
        }
    }

    public void approveSelection(String string) {
        if (string.equals("ApproveSelection")) {
            if (this.mode == 1) {
                File file = this.fileChooser.getSelectedFile();
                if (file.exists()) {
                    Object[] objectArray = new Object[]{"Plik \"" + file.getName() + "\" ju\u017c istnieje.", "Czy chcesz go zamieni\u0107?"};
                    int n = JOptionPane.showConfirmDialog(this, objectArray, "File Exists", 1, 3);
                    if (n == 0) {
                        this.accepted = true;
                        this.setVisible(false);
                    } else if (n == 1) {
                        this.accepted = false;
                        this.setVisible(false);
                    } else {
                        this.accepted = false;
                    }
                } else {
                    this.accepted = true;
                    this.setVisible(false);
                }
            } else {
                this.accepted = true;
                this.setVisible(false);
            }
        } else {
            this.accepted = false;
            this.setVisible(false);
        }
    }

    public void setSelectedFile(File file) {
        this.fileChooser.setSelectedFile(file);
    }

    public File getSelectedFile() {
        return this.fileChooser.getSelectedFile();
    }

    public void setCurrentDirectory(File file) {
        this.fileChooser.setCurrentDirectory(file);
    }

    public File getCurrentDirectory() {
        return this.fileChooser.getCurrentDirectory();
    }

    public String getEncoding() {
        String[] stringArray = ((String)this.encodingsCombo.getSelectedItem()).split(" ");
        return stringArray[0].trim();
    }

    public boolean accept() {
        return this.accepted;
    }
}

